export const getToken = () => {
  if (typeof document === "undefined") return null;

  const match = document.cookie.match(/(^| )token=([^;]+)/);
  return match ? match[2] : null;
};

export const getUser = () => {
  if (typeof window === "undefined") return null;

  const user = localStorage.getItem("user");
  return user ? JSON.parse(user) : null;
};

export const logout = () => {
  // ✅ cookie clear (MOST IMPORTANT)
  document.cookie = "token=; path=/; max-age=0";

  // ✅ optional user data clear
  localStorage.removeItem("user");

  window.location.href = "/login";
};
