"use client";

import { useEffect, useState } from "react";
import {
  X,
  ChevronDown,
  Search,
  Truck,
  DollarSign,
  Clock,
} from "lucide-react";


import Slider from "./components/home/Slider";
import HomeCategories from "./components/home/HomeCategories";
import FeaturedProducts from "./components/home/FeaturedProducts";
import OfferdProducts from "./components/home/OfferdProducts";
import PromoCarousel from "./components/home/PromoCarousel";
import PromoAndFeatured from "./components/home/_PromoAndFeatured";
import PromoSidebar from "./components/home/PromoSidebar";
import Newsletter from "./components/home/Newsletter";
import PromoBanner from "./components/home/PromoBanner";
import ProductCard from "./components/home/FeaturedProductCard";

import { ChevronLeft, ChevronRight } from "lucide-react";
import BrandLogos from "./components/home/BrandLogos";
import TopRatedProducts from "./components/home/TopRatedProducts";


export default function HomePage() {
  const [cartOpen, setCartOpen] = useState(false);
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);

  const [activeProduct, setActiveProduct] = useState(0);


  return (
    <div className="min-h-screen bg-white font-sans">

      <div className="border-b border-gray-200 py-4">
        <div className="max-w-7xl mx-auto px-4">
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div className="flex items-center gap-3">
              <Truck size={40} className="text-gray-700" />
              <div>
                <div className="font-semibold text-sm">
                  FREE SHIPPING & RETURN
                </div>
                <div className="text-xs text-gray-500">
                  Free shipping on all orders over $99
                </div>
              </div>
            </div>
            <div className="flex items-center gap-3">
              <DollarSign size={40} className="text-gray-700" />
              <div>
                <div className="font-semibold text-sm">
                  MONEY BACK GUARANTEE
                </div>
                <div className="text-xs text-gray-500">
                  100% money back guarantee
                </div>
              </div>
            </div>
            <div className="flex items-center gap-3">
              <Clock size={40} className="text-gray-700" />
              <div>
                <div className="font-semibold text-sm">ONLINE SUPPORT 24/7</div>
                <div className="text-xs text-gray-500">
                  Lorem ipsum dolor sit amet.
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>


      <main className="max-w-7xl mx-auto">

        {/* Main Content Section */}
        <div className="container mx-auto px-4 py-12">
          <div className="grid grid-cols-1 lg:grid-cols-12 gap-8">
            {/* Left Sidebar */}
            <div className="lg:col-span-3 space-y-8">
              <HomeCategories />
              <PromoSidebar />
              <Newsletter />
            </div>

            {/* Main Content */}
            <div className="lg:col-span-9 space-y-8">
              <Slider />
              {/* Promo Banners */}
              <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
                <PromoBanner />

              </div>

              {/* Featured Products */}
              <FeaturedProducts />
              {/* Featured Products */}

              {/* Offer Products */}
              <OfferdProducts />
              {/* Offer Products */}




              {/* Brand Logo */}
              <BrandLogos />

              <TopRatedProducts />

            </div>
          </div>
        </div>






      </main>



      {/* {cartOpen && (
        <>
          <div
            className="fixed inset-0 bg-black bg-opacity-50 z-40"
            onClick={() => setCartOpen(false)}
          ></div>
          <div className="fixed right-0 top-0 h-full w-full max-w-md bg-white shadow-2xl z-50 overflow-y-auto">
            <div className="p-6">
              <div className="flex items-center justify-between mb-6">
                <h2 className="text-xl font-semibold">Shopping Cart</h2>
                <button
                  onClick={() => setCartOpen(false)}
                  className="p-2 hover:bg-gray-100 rounded transition-colors"
                >
                  <X size={24} />
                </button>
              </div>

              <div className="space-y-4 mb-6">
                {cartItems.map((item) => (
                  <div
                    key={item.id}
                    className="flex gap-4 pb-4 border-b border-gray-200"
                  >
                    <img
                      src={item.image}
                      alt={item.name}
                      className="w-20 h-20 object-cover rounded"
                    />
                    <div className="flex-1">
                      <h3 className="text-sm font-medium mb-2">{item.name}</h3>
                      <div className="flex items-center justify-between">
                        <span className="text-sm">
                          {item.quantity} × ${item.price.toFixed(2)}
                        </span>
                      </div>
                    </div>
                    <button className="text-gray-400 hover:text-red-500 transition-colors">
                      <X size={18} />
                    </button>
                  </div>
                ))}
              </div>

              <div className="border-t border-gray-200 pt-4 mb-6">
                <div className="flex items-center justify-between text-lg font-semibold">
                  <span>SUBTOTAL:</span>
                  <span className="text-[#0088CC]">$134.00</span>
                </div>
              </div>

              <div className="space-y-3">
                <button className="w-full bg-white text-[#0088CC] border-2 border-[#0088CC] py-3 rounded font-semibold hover:bg-[#0088CC] hover:text-white transition-colors">
                  VIEW CART
                </button>
                <button className="w-full bg-[#0088CC] text-white py-3 rounded font-semibold hover:bg-[#0077B3] transition-colors">
                  CHECKOUT
                </button>
              </div>
            </div>
          </div>
        </>
      )} */}

      {mobileMenuOpen && (
        <>
          <div
            className="fixed inset-0 bg-black bg-opacity-50 z-40"
            onClick={() => setMobileMenuOpen(false)}
          ></div>
          <div className="fixed left-0 top-0 h-full w-full max-w-xs bg-[#2B2B2D] text-white shadow-2xl z-50 overflow-y-auto">
            <div className="p-6">
              <button
                onClick={() => setMobileMenuOpen(false)}
                className="absolute top-4 right-4 text-white hover:text-gray-400 transition-colors"
              >
                <X size={24} />
              </button>

              <nav className="mt-8 space-y-1">
                {menuItems.map((item, index) => (
                  <div key={index}>
                    <a
                      href="#"
                      className="flex items-center justify-between py-3 px-4 hover:bg-gray-700 rounded transition-colors"
                    >
                      <div className="flex items-center gap-3">
                        <item.icon size={20} />
                        <span className="uppercase text-sm">{item.label}</span>
                        {item.badge && (
                          <span className="bg-red-500 text-white text-xs px-2 py-0.5 rounded">
                            {item.badge}
                          </span>
                        )}
                      </div>
                      {item.hasSubmenu && <ChevronDown size={16} />}
                    </a>
                  </div>
                ))}
              </nav>

              <div className="mt-8 pt-6 border-t border-gray-700 space-y-3">
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  MY ACCOUNT
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  CONTACT US
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  MY WISHLIST
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  SITE MAP
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  CART
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  LOG IN
                </a>
              </div>

              <div className="mt-6 pt-6 border-t border-gray-700">
                <div className="relative mb-4">
                  <input
                    type="text"
                    placeholder="Search..."
                    className="w-full px-4 py-2 bg-gray-700 text-white rounded focus:outline-none focus:ring-2 focus:ring-[#0088CC]"
                  />
                  <Search
                    size={20}
                    className="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400"
                  />
                </div>

                <div className="flex items-center justify-center gap-4">
                  <a
                    href="#"
                    className="w-10 h-10 bg-[#3B5998] flex items-center justify-center rounded hover:bg-opacity-80 transition-colors"
                    aria-label="Facebook"
                  >
                    <Facebook size={18} />
                  </a>
                  <a
                    href="#"
                    className="w-10 h-10 bg-[#1DA1F2] flex items-center justify-center rounded hover:bg-opacity-80 transition-colors"
                    aria-label="Twitter"
                  >
                    <Twitter size={18} />
                  </a>
                  <a
                    href="#"
                    className="w-10 h-10 bg-gradient-to-r from-[#F58529] via-[#DD2A7B] to-[#8134AF] flex items-center justify-center rounded hover:opacity-80 transition-opacity"
                    aria-label="Instagram"
                  >
                    <Instagram size={18} />
                  </a>
                </div>
              </div>
            </div>
          </div>
        </>
      )}
    </div>
  );
}
