import { NextResponse } from "next/server";

export function middleware(request) {
  const tokenCookie = request.cookies.get("token");
  const token = tokenCookie?.value;

  const { pathname } = request.nextUrl;

  const protectedRoutes = ["/checkout", "/dashboard", "/user"];

  const isInvalidToken = !token || token === "undefined" || token === "null";

  if (isInvalidToken && protectedRoutes.some(p => pathname.startsWith(p))) {
    const loginUrl = new URL("/login", request.url);
    loginUrl.searchParams.set("redirect", pathname);
    return NextResponse.redirect(loginUrl);
  }
}

export const config = {
  matcher: ["/checkout/:path*", "/dashboard/:path*", "/user/:path*"],
};
