"use client";

import { useState } from "react";
import { useRouter } from "next/navigation";

export default function LoginPage() {
  const router = useRouter();


  const [username, setUsername] = useState("");
  const [password, setPassword] = useState("");
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState("");

  const submitLogin = async (e) => {
    e.preventDefault();
    setLoading(true);
    setError("");

    try {
      const res = await fetch(
        `${process.env.NEXT_PUBLIC_API_URL}/login`,
        {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          credentials: "include",
          body: JSON.stringify({ username, password }),
        }
      );

      const data = await res.json();

      if (data.status !== "success") {
        throw new Error(data.message);
      }

      // ✅ TOKEN → COOKIE
      document.cookie = `token=${data.token}; path=/; max-age=${60 * 60 * 24}`;

      // ✅ USER → localStorage
      localStorage.setItem("user", JSON.stringify(data.user));

      // 🔥 IMPORTANT: redirect to intended page
      window.location.href = '/dashboard';

    } catch (err) {
      setError(err.message);
    } finally {
      setLoading(false);
    }
  };

  return (
    <div className="max-w-md mx-auto my-24">
      <h1 className="text-2xl mb-4 font-semibold">Login</h1>

      <form onSubmit={submitLogin} className="space-y-4">
        <input
          className="w-full border px-3 py-2"
          placeholder="Username"
          value={username}
          onChange={(e) => setUsername(e.target.value)}
        />

        <input
          type="password"
          className="w-full border px-3 py-2"
          placeholder="Password"
          value={password}
          onChange={(e) => setPassword(e.target.value)}
        />

        {error && <p className="text-red-600">{error}</p>}

        <button className="w-full bg-black text-white py-2">
          {loading ? "Logging in..." : "Login"}
        </button>
      </form>
    </div>
  );
}
