"use client";

import { useEffect, useState } from "react";
import {
  X,
  ChevronDown,
  Search,
  Phone,
  User,
  Heart,
  ShoppingCart,
  Home as HomeIcon,
  Tag,
  ShoppingBag,
  FileText,
  BookOpen,
  Info,
  Gift,
  Star,
  Truck,
  DollarSign,
  Clock,
  Menu,
  ChevronRight,
} from "lucide-react";



import { Facebook, Twitter, Instagram } from "lucide-react";

export default function HomePage() {
  const [showTopBanner, setShowTopBanner] = useState(true);
  const [cartOpen, setCartOpen] = useState(false);
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);
  const [languageOpen, setLanguageOpen] = useState(false);
  const [currencyOpen, setCurrencyOpen] = useState(false);
  const [hoveredMenuItem, setHoveredMenuItem] = useState(null);


  const slides = [
    {
      title: "Summer Sale",
      img: "http://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/slider/slide-1.png",
    },
    {
      title: "Winter Collection",
      img: "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/slider/slide-2.jpg",
    },
    {
      title: "Autumn Deals",
      img: "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/slider/slide-3.jpg",
    }
  ];

  const [current, setCurrent] = useState(0);

  // Auto play every 3 seconds
  useEffect(() => {
    const timer = setInterval(() => {
      setCurrent((prev) => (prev + 1) % slides.length);
    }, 7000);
    return () => clearInterval(timer);
  }, [slides.length]);



  const cartItems = [
    {
      id: 1,
      name: "Ultimate 3D Bluetooth Speaker",
      price: 34.0,
      quantity: 1,
      image: "https://via.placeholder.com/80x80",
    },
    {
      id: 2,
      name: "Brown Women Casual HandBag",
      price: 35.0,
      quantity: 1,
      image: "https://via.placeholder.com/80x80",
    },
    {
      id: 3,
      name: "Circled Ultimate 3D Speaker",
      price: 35.0,
      quantity: 1,
      image: "https://via.placeholder.com/80x80",
    },
  ];

  const menuItems = [
    { icon: HomeIcon, label: "Home", hasSubmenu: false },
    {
      icon: Tag,
      label: "Categories",
      hasSubmenu: true,
      submenu: ["Electronics", "Fashion", "Home & Garden"],
    },
    {
      icon: ShoppingBag,
      label: "Products",
      hasSubmenu: true,
      submenu: {
        "PRODUCT PAGES": [
          "SIMPLE PRODUCT",
          "VARIABLE PRODUCT",
          "SALE PRODUCT",
          "FEATURED & ON SALE",
          "WITH CUSTOM TAB",
          "WITH LEFT SIDEBAR",
          "WITH RIGHT SIDEBAR",
          "ADD CART STICKY",
        ],
        "PRODUCT LAYOUTS": [
          "EXTENDED LAYOUT",
          "GRID IMAGE",
          "FULL WIDTH LAYOUT",
          "STICKY INFO",
          "LEFT & RIGHT STICKY",
          "TRANSPARENT IMAGE",
          "CENTER VERTICAL",
          "BUILD YOUR OWN",
        ],
      },
    },
    {
      icon: FileText,
      label: "Pages",
      hasSubmenu: true,
      submenu: ["About", "Contact", "FAQ"],
    },
    { icon: BookOpen, label: "Blog", hasSubmenu: false },
    { icon: Info, label: "About Us", hasSubmenu: false },
    { icon: Gift, label: "Special Offer!", hasSubmenu: false },
    { icon: Star, label: "Buy Porto!", badge: "HOT", hasSubmenu: false },
  ];

  return (
    <div className="min-h-screen bg-white font-sans">




  

      <main className="max-w-7xl mx-auto px-4 py-6">
        <div className="flex gap-6">
          


         


        </div>
      </main>

      {cartOpen && (
        <>
          <div
            className="fixed inset-0 bg-black bg-opacity-50 z-40"
            onClick={() => setCartOpen(false)}
          ></div>
          <div className="fixed right-0 top-0 h-full w-full max-w-md bg-white shadow-2xl z-50 overflow-y-auto">
            <div className="p-6">
              <div className="flex items-center justify-between mb-6">
                <h2 className="text-xl font-semibold">Shopping Cart</h2>
                <button
                  onClick={() => setCartOpen(false)}
                  className="p-2 hover:bg-gray-100 rounded transition-colors"
                >
                  <X size={24} />
                </button>
              </div>

              <div className="space-y-4 mb-6">
                {cartItems.map((item) => (
                  <div
                    key={item.id}
                    className="flex gap-4 pb-4 border-b border-gray-200"
                  >
                    <img
                      src={item.image}
                      alt={item.name}
                      className="w-20 h-20 object-cover rounded"
                    />
                    <div className="flex-1">
                      <h3 className="text-sm font-medium mb-2">{item.name}</h3>
                      <div className="flex items-center justify-between">
                        <span className="text-sm">
                          {item.quantity} × ${item.price.toFixed(2)}
                        </span>
                      </div>
                    </div>
                    <button className="text-gray-400 hover:text-red-500 transition-colors">
                      <X size={18} />
                    </button>
                  </div>
                ))}
              </div>

              <div className="border-t border-gray-200 pt-4 mb-6">
                <div className="flex items-center justify-between text-lg font-semibold">
                  <span>SUBTOTAL:</span>
                  <span className="text-[#0088CC]">$134.00</span>
                </div>
              </div>

              <div className="space-y-3">
                <button className="w-full bg-white text-[#0088CC] border-2 border-[#0088CC] py-3 rounded font-semibold hover:bg-[#0088CC] hover:text-white transition-colors">
                  VIEW CART
                </button>
                <button className="w-full bg-[#0088CC] text-white py-3 rounded font-semibold hover:bg-[#0077B3] transition-colors">
                  CHECKOUT
                </button>
              </div>
            </div>
          </div>
        </>
      )}

      {mobileMenuOpen && (
        <>
          <div
            className="fixed inset-0 bg-black bg-opacity-50 z-40"
            onClick={() => setMobileMenuOpen(false)}
          ></div>
          <div className="fixed left-0 top-0 h-full w-full max-w-xs bg-[#2B2B2D] text-white shadow-2xl z-50 overflow-y-auto">
            <div className="p-6">
              <button
                onClick={() => setMobileMenuOpen(false)}
                className="absolute top-4 right-4 text-white hover:text-gray-400 transition-colors"
              >
                <X size={24} />
              </button>

              <nav className="mt-8 space-y-1">
                {menuItems.map((item, index) => (
                  <div key={index}>
                    <a
                      href="#"
                      className="flex items-center justify-between py-3 px-4 hover:bg-gray-700 rounded transition-colors"
                    >
                      <div className="flex items-center gap-3">
                        <item.icon size={20} />
                        <span className="uppercase text-sm">{item.label}</span>
                        {item.badge && (
                          <span className="bg-red-500 text-white text-xs px-2 py-0.5 rounded">
                            {item.badge}
                          </span>
                        )}
                      </div>
                      {item.hasSubmenu && <ChevronDown size={16} />}
                    </a>
                  </div>
                ))}
              </nav>

              <div className="mt-8 pt-6 border-t border-gray-700 space-y-3">
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  MY ACCOUNT
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  CONTACT US
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  MY WISHLIST
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  SITE MAP
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  CART
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  LOG IN
                </a>
              </div>

              <div className="mt-6 pt-6 border-t border-gray-700">
                <div className="relative mb-4">
                  <input
                    type="text"
                    placeholder="Search..."
                    className="w-full px-4 py-2 bg-gray-700 text-white rounded focus:outline-none focus:ring-2 focus:ring-[#0088CC]"
                  />
                  <Search
                    size={20}
                    className="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400"
                  />
                </div>

                <div className="flex items-center justify-center gap-4">
                  <a
                    href="#"
                    className="w-10 h-10 bg-[#3B5998] flex items-center justify-center rounded hover:bg-opacity-80 transition-colors"
                    aria-label="Facebook"
                  >
                    <Facebook size={18} />
                  </a>
                  <a
                    href="#"
                    className="w-10 h-10 bg-[#1DA1F2] flex items-center justify-center rounded hover:bg-opacity-80 transition-colors"
                    aria-label="Twitter"
                  >
                    <Twitter size={18} />
                  </a>
                  <a
                    href="#"
                    className="w-10 h-10 bg-gradient-to-r from-[#F58529] via-[#DD2A7B] to-[#8134AF] flex items-center justify-center rounded hover:opacity-80 transition-opacity"
                    aria-label="Instagram"
                  >
                    <Instagram size={18} />
                  </a>
                </div>
              </div>
            </div>
          </div>
        </>
      )}
    </div>
  );
}
