import { Check } from "lucide-react";
import { cn } from "@/lib/utils";

interface Color {
  name: string;
  value: string;
  class: string;
}

interface ColorSelectorProps {
  colors: Color[];
  selected: string;
  onChange: (color: string) => void;
}

export const ColorSelector = ({ colors, selected, onChange }: ColorSelectorProps) => {
  return (
    <div className="flex items-center gap-2 flex-wrap">
      {colors.map((color) => (
        <button
          key={color.value}
          onClick={() => onChange(color.value)}
          className={cn(
            "w-8 h-8 rounded border-2 flex items-center justify-center transition-all",
            color.class,
            selected === color.value
              ? "border-primary ring-2 ring-primary ring-offset-2"
              : "border-gray-300 hover:border-gray-400"
          )}
          title={color.name}
          aria-label={`Select ${color.name} color`}
        >
          {selected === color.value && (
            <Check className="w-4 h-4 text-white drop-shadow" />
          )}
        </button>
      ))}
    </div>
  );
};
