"use client";
import { useState } from "react";

export default function PromoAndFeatured() {
    const [activePromo, setActivePromo] = useState(0);
    const [activeProduct, setActiveProduct] = useState(0);

    const promoItems = [
        {
            title: "DRONE + CAMERAS",
            subtitle: "UP TO $100 OFF",
            description: "Top Brands and Models!",
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-2.jpg",
        },
        {
            title: "ACTION CAMS",
            subtitle: "SAVE UP TO $80",
            description: "Capture Every Moment",
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-3.jpg",
        },
        {
            title: "DSLR DEALS",
            subtitle: "EXTRA 20% OFF",
            description: "Pro Gear, Pro Price",
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-4.jpg",
        },
    ];

    const products = [
        {
            name: "Block Grey Headset",
            category: "Headphone",
            price: "$9.00",
            tags: ["HOT", "-20%"],
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-4.jpg",
        },
        {
            name: "Battery Charger",
            category: "Electronics",
            price: "$9.00",
            tags: ["HOT", "SALE"],
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-3.jpg",
        },
        {
            name: "Brown Bag",
            category: "Handbag",
            price: "$9.00",
            tags: ["HOT", "-30%"],
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-2.jpg",
        },
        {
            name: "Casual Note Bag",
            category: "Handbag",
            price: "$9.00",
            tags: [],
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-1.jpg",
        },
        {
            name: "Block Grey Headset",
            category: "Headphone",
            price: "$9.00",
            tags: ["HOT", "-20%"],
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-4.jpg",
        },
        {
            name: "Battery Charger",
            category: "Electronics",
            price: "$9.00",
            tags: ["HOT", "SALE"],
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-3.jpg",
        },
        {
            name: "Brown Bag",
            category: "Handbag",
            price: "$9.00",
            tags: ["HOT", "-30%"],
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-2.jpg",
        },
        {
            name: "Casual Note Bag",
            category: "Handbag",
            price: "$9.00",
            tags: [],
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-1.jpg",
        },
    ];

    return (
        <div className="flex flex-col md:flex-row gap-6 py-12 px-4 max-w-7xl mx-auto">
            {/* PromoCarousel - 30% */}
            <div className="md:w-[20%]">
                <div className="overflow-hidden border border-gray-200">
                    <div
                        className="flex transition-transform duration-500"
                        style={{ transform: `translateX(-${activePromo * 100}%)` }}
                    >
                        {promoItems.map((item, idx) => (
                            <div key={idx} className="min-w-full bg-white p-6 text-center">
                                <img
                                    src={item.image}
                                    alt={item.title}
                                    className="mx-auto h-32 object-contain mb-4"
                                />
                                <h3 className="text-lg font-bold">{item.title}</h3>
                                <p className="text-xl font-bold text-blue-600 mt-1">
                                    {item.subtitle}
                                </p>
                                <p className="text-sm text-gray-500 mt-1">{item.description}</p>
                                <button className="mt-4 bg-black text-white px-4 py-2 rounded hover:bg-gray-800">
                                    VIEW SALE
                                </button>
                                {/* Dots inside section */}

                            </div>
                        ))}

                    </div>
                
                <div className="flex justify-center gap-2 mb-6">
  {promoItems.map((_, dotIdx) => (
    <button
      key={dotIdx}
      onClick={() => setActivePromo(dotIdx)}
      className={`w-2.5 h-2.5 rounded-full border-3 transition-all duration-300
        ${activePromo === dotIdx 
          ? "bg-blue-100 border-blue-600" 
          : "bg-white border-gray-400"
        }`}
    />
  ))}
</div>


                </div>
            </div>

            {/* FeaturedProducts - 70% */}
            <div className="md:w-[80%]">
                <div className="flex justify-between items-center mb-6">
                    <h2 className="text-2xl font-bold">Featured Products</h2>
                    <div className="flex gap-2">
                        {[0, 1].map((dotIdx) => (
                            <button
                                key={dotIdx}
                                onClick={() => setActiveProduct(dotIdx)}
                                    className={`w-2.5 h-2.5 rounded-full border-3 transition-all duration-300
        ${activeProduct === dotIdx 
          ? "bg-blue-100 border-blue-400" 
          : "bg-white border-gray-400"
        }`}

                            />
                        ))}
                    </div>
                </div>

                <div className="overflow-hidden">
                    <div
                        className="flex transition-transform duration-500"
                        style={{ transform: `translateX(-${activeProduct * 100}%)` }}
                    >
                        {products.map((product, idx) => (
                            <div
                                key={idx}
                                className="min-w-full md:min-w-[25%] p-4 relative group hover:shadow-lg transition duration-300"
                            >
                                <img
                                    src={product.image}
                                    alt={product.name}
                                    className="w-full h-40 object-cover rounded"
                                />
                                <div className="absolute top-2 left-2 flex gap-2">
                                    {product.tags.map((tag, i) => (
                                        <span
                                            key={i}
                                            className={`text-xs px-2 py-1 rounded-full ${tag.includes("%") ? "bg-red-500" : "bg-green-500"
                                                } text-white`}
                                        >
                                            {tag}
                                        </span>
                                    ))}
                                </div>

                                {/* Hover Buttons */}
                                <div className="absolute inset-0 bg-black bg-opacity-30 flex items-center justify-center gap-2 opacity-0 group-hover:opacity-100 transition">
                                    <button className="bg-white text-sm px-3 py-1 rounded hover:bg-blue-600 hover:text-white">
                                        View
                                    </button>
                                    <button className="bg-white text-sm px-3 py-1 rounded hover:bg-blue-600 hover:text-white">
                                        Add to Cart
                                    </button>
                                </div>

                                <p className="text-sm text-gray-500 mt-2">
                                    {product.category}
                                </p>
                                <h3 className="font-semibold text-lg">{product.name}</h3>
                                <div className="flex items-center mt-1">
                                    {[...Array(5)].map((_, i) => (
                                        <span key={i} className="text-yellow-500 text-sm">
                                            ★
                                        </span>
                                    ))}
                                </div>
                                <p className="text-blue-600 font-bold mt-2">{product.price}</p>
                            </div>
                        ))}
                    </div>
                </div>
            </div>
        </div>
    );
}
