"use client";

import { useEffect, useState } from "react";


const TopRatedProducts = () => {

      const [count, setCount] = useState(0);

  useEffect(() => {
    setCount(Math.floor(Math.random() * 5) + 1);
  }, []);


    const topRatedProducts = [
        {
            id: 1,
            image: "https://id-preview--753e56e4-39d6-4da2-afe3-212de7bb8ae3.lovable.app/assets/watch-product-CKNdCwrs.jpg",
            title: "Porto Extended Camera",
            category: "CAMERAS",
            price: 45.00,
            rating: 5
        },
        {
            id: 2,
            image: "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/small/product-4-2.jpg",
            title: "Porto Extended Camera",
            category: "CAMERAS",
            price: 45.00,
            rating: 5
        },
        {
            id: 3,
            image: "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/small/product-5-2.jpg",
            title: "Porto Extended Camera",
            category: "CAMERAS",
            price: 45.00,
            rating: 5
        },
    ];

    const bestSellingProducts = [
        {
            id: 1,
            image: "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/small/product-6-2.jpg",
            title: "Porto Extended Camera",
            category: "CAMERAS",
            price: 45.00,
            rating: 5
        },
        {
            id: 2,
            image: "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/small/product-7-2.jpg",
            title: "Porto Extended Camera",
            category: "CAMERAS",
            price: 45.00,
            rating: 5
        },
        {
            id: 3,
            image: "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/small/product-11-2.jpg",
            title: "Porto Extended Camera",
            category: "CAMERAS",
            price: 45.00,
            rating: 5
        },
    ];


    return (
        <>
            {/* Product Lists */}
            <div className="grid grid-cols-3 gap-8 mb-12">
                <div>
                    <h3 className="text-xl font-bold mb-6 pb-2 border-b">TOP RATED PRODUCTS</h3>
                    <div className="space-y-4">
                        {topRatedProducts.map((product) => (
                            <div key={product.id} className="flex gap-4">
                                <img src={product.image} alt={product.title} className="w-20 h-20 object-cover grayscale" />
                                <div className="flex-1">
                                    <p className="text-xs text-gray-400 mb-1">{product.category}</p>
                                    <h4 className="font-semibold text-sm mb-1 text-gray-500">{product.title}</h4>
                                    <div className="flex items-center gap-1 mb-1">
                                       {[...Array(count)].map((_, i) => (
        <span key={i} className="text-xs text-gray-400">★</span>
      ))}
                                    </div>
                                    <p className="font-bold text-gray-500">${product.price.toFixed(2)}</p>
                                </div>
                            </div>
                        ))}
                    </div>
                </div>

                <div>
                    <h3 className="text-xl font-bold mb-6 pb-2 border-b">BEST SELLING PRODUCTS</h3>
                    <div className="space-y-4">
                        {bestSellingProducts.map((product) => (
                            <div key={product.id} className="flex gap-4">
                                <img src={product.image} alt={product.title} className="w-20 h-20 object-cover grayscale" />
                                <div className="flex-1">
                                    <p className="text-xs text-gray-400 mb-1">{product.category}</p>
                                    <h4 className="font-semibold text-sm mb-1 text-gray-500">{product.title}</h4>
                                    <div className="flex items-center gap-1 mb-1">
                                        {[...Array(count)].map((_, i) => (
        <span key={i} className="text-xs text-gray-400">★</span>
      ))}
                                    </div>
                                    <p className="font-bold text-gray-500">${product.price.toFixed(2)}</p>
                                </div>
                            </div>
                        ))}
                    </div>
                </div>




                <div>
                    <h3 className="text-xl font-bold mb-6 pb-2 border-b">LATEST PRODUCTS</h3>
                    <div className="space-y-4">
                        {topRatedProducts.map((product) => (
                            <div key={product.id} className="flex gap-4">
                                <img src={product.image} alt={product.title} className="w-20 h-20 object-cover grayscale" />
                                <div className="flex-1">
                                    <p className="text-xs text-gray-400 mb-1">{product.category}</p>
                                    <h4 className="font-semibold text-sm mb-1 text-gray-500">{product.title}</h4>
                                    <div className="flex items-center gap-1 mb-1">
                                       {[...Array(count)].map((_, i) => (
        <span key={i} className="text-xs text-gray-400">★</span>
      ))}
                                    </div>
                                    <p className="font-bold text-gray-500">${product.price.toFixed(2)}</p>
                                </div>
                            </div>
                        ))}
                    </div>
                </div>



            </div>
        </>
    );
};

export default TopRatedProducts;
