"use client";

import { useEffect, useState } from "react";


const API_URL = `${process.env.NEXT_PUBLIC_API_URL}/sliders`;
const IMAGE_BASE = `${process.env.NEXT_PUBLIC_IMAGE_BASE}/frontend/banner_sliders/`;

export default function Slider() {
  const [slides, setSlides] = useState([]);
  const [current, setCurrent] = useState(0);

  // Fetch sliders
  useEffect(() => {
    fetch(API_URL)
      .then(res => res.json())
      .then(res => {
        if (res.status === "success") {
          setSlides(res.data);
        }
      })
      .catch(err => console.error("Slider load failed", err));
  }, []);

  // Auto play
  useEffect(() => {
    if (!slides.length) return;

    const timer = setInterval(() => {
      setCurrent(prev => (prev + 1) % slides.length);
    }, 7000);

    return () => clearInterval(timer);
  }, [slides.length]);

  if (!slides.length) return null; // or loader

  return (
    <div className="relative w-full overflow-hidden">
      <div
        className="flex transition-transform duration-1000 ease-in-out"
        style={{
          transform: `translateX(-${current * 70}vw)`,
          width: `${slides.length * 70}vw`,
        }}
      >
        {slides.map((slide, i) => (
          <div key={slide.id} className="w-[70vw] flex-shrink-0">
            <div className="relative h-[250px] sm:h-[300px] md:h-[350px] lg:h-[420px] overflow-hidden bg-black">

              {/* Slider image */}
              <a href={slide.data_values?.link || "#"}>
                {slide.data_values?.slider && (
                  <img
                    src={IMAGE_BASE + slide.data_values.slider}
                    alt="Slider"
                    className="absolute inset-0 w-full h-full object-cover"
                  />
                )}

              </a>

              {/* Overlay content (optional static text) */}
              {/* <div className="relative flex items-center h-full text-white">
                <div className="p-6 lg:p-10">
                  <h2 className="text-3xl lg:text-4xl font-bold mb-3">
                    Special Offer
                  </h2>
                  <button className="bg-black px-6 py-2 rounded font-semibold">
                    Shop Now
                  </button>
                </div>
              </div> */}

            </div>
          </div>
        ))}
      </div>

      {/* Dots */}
      <div className="absolute bottom-4 left-6 flex gap-2 z-20">
        {slides.map((_, i) => (
          <button
            key={i}
            onClick={() => setCurrent(i)}
            className={`w-3 h-3 rounded-full ${current === i ? "bg-white" : "bg-white/50"
              }`}
          />
        ))}
      </div>
    </div>
  );
}
