import { useState } from "react";
import { ChevronRight } from "lucide-react";

export default function RecursiveMenu({ items }) {
  const [activeIndex, setActiveIndex] = useState(null);

  return (
    <div className="bg-white border shadow-md w-64">
      {items.map((item, index) => (
        <div
          key={item.id}
          className="relative"
          onMouseEnter={() => setActiveIndex(index)}
          onMouseLeave={() => setActiveIndex(null)}
        >
          <div className="flex justify-between items-center px-4 py-2 hover:bg-gray-100 cursor-pointer">
             <a href={`/category/${item.id}`}> <span className="text-sm text-gray-700">{item.name}</span> </a>
          
            {item.all_subcategories?.length > 0 && (
              <ChevronRight size={14} />
            )}
          </div>

          {/* NEXT LEVEL */}
          {item.all_subcategories?.length > 0 && (
            <div
              className={`
                absolute left-full top-0
                transition-all duration-200 ease-out
                ${activeIndex === index
                  ? "opacity-100 translate-x-0 pointer-events-auto"
                  : "opacity-0 translate-x-3 pointer-events-none"}
              `}
            >
              <RecursiveMenu items={item.all_subcategories} />
            </div>
          )}
        </div>
      ))}
    </div>
  );
}
