import { useState } from "react";

const PromoSidebar = () => {

 const [activePromo, setActivePromo] = useState(0);
      const promoItems = [
        {
            title: "DRONE + CAMERAS",
            subtitle: "UP TO $100 OFF",
            description: "Top Brands and Models!",
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-2.jpg",
        },
        {
            title: "ACTION CAMS",
            subtitle: "SAVE UP TO $80",
            description: "Capture Every Moment",
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-3.jpg",
        },
        {
            title: "DSLR DEALS",
            subtitle: "EXTRA 20% OFF",
            description: "Pro Gear, Pro Price",
            image:
                "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-4.jpg",
        },
    ];

  return (
    <div className="overflow-hidden border border-gray-200">
                    <div
                        className="flex transition-transform duration-500"
                        style={{ transform: `translateX(-${activePromo * 100}%)` }}
                    >
                        {promoItems.map((item, idx) => (
                            <div key={idx} className="min-w-full bg-white p-6 text-center">
                                <img
                                    src={item.image}
                                    alt={item.title}
                                    className="mx-auto h-32 object-contain mb-4"
                                />
                                <h3 className="text-lg font-bold">{item.title}</h3>
                                <p className="text-xl font-bold text-blue-600 mt-1">
                                    {item.subtitle}
                                </p>
                                <p className="text-sm text-gray-500 mt-1">{item.description}</p>
                                <button className="mt-4 bg-black text-white px-4 py-2 rounded hover:bg-gray-800">
                                    VIEW SALE
                                </button>
                                {/* Dots inside section */}

                            </div>
                        ))}

                    </div>
                
                <div className="flex justify-center gap-2 mb-6">
  {promoItems.map((_, dotIdx) => (
    <button
      key={dotIdx}
      onClick={() => setActivePromo(dotIdx)}
      className={`w-2.5 h-2.5 rounded-full border-3 transition-all duration-300
        ${activePromo === dotIdx 
          ? "bg-blue-100 border-blue-600" 
          : "bg-white border-gray-400"
        }`}
    />
  ))}
</div>


                </div>
  );
};

export default PromoSidebar;
