"use client";
import { useState } from 'react';

const items = [
  {
    title: 'DRONE + CAMERAS',
    subtitle: 'UP TO $100 OFF',
    description: 'Top Brands and Models!',
    image: 'https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-2.jpg',
  },
  {
    title: 'ACTION CAMS',
    subtitle: 'SAVE UP TO $80',
    description: 'Capture Every Moment',
    image: 'https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-3.jpg',
  },
  {
    title: 'DSLR DEALS',
    subtitle: 'EXTRA 20% OFF',
    description: 'Pro Gear, Pro Price',
    image: 'https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-4.jpg',
  },
];


export default function PromoCarousel() {
  const [activeIndex, setActiveIndex] = useState(0);

  return (
    <div className="w-full md:w-1/2 p-4">
      <div className="overflow-hidden rounded-lg border">
        <div className="flex transition-transform duration-500" style={{ transform: `translateX(-${activeIndex * 100}%)` }}>
          {items.map((item, idx) => (
            <div key={idx} className="min-w-full bg-white p-6 text-center">
              <img src={item.image} alt={item.title} className="mx-auto h-32 object-contain mb-4" />
              <h3 className="text-lg font-bold">{item.title}</h3>
              <p className="text-xl font-bold text-blue-600 mt-1">{item.subtitle}</p>
              <p className="text-sm text-gray-500 mt-1">{item.description}</p>
              <button className="mt-4 bg-black text-white px-4 py-2 rounded hover:bg-gray-800">VIEW SALE</button>
            </div>
          ))}
        </div>
      </div>

      {/* Pagination Dots */}
      <div className="flex justify-center gap-2 mt-4">
        {items.map((_, idx) => (
          <button
            key={idx}
            onClick={() => setActiveIndex(idx)}
            className={`w-3 h-3 rounded-full ${activeIndex === idx ? 'bg-blue-600' : 'bg-gray-300'}`}
          />
        ))}
      </div>
    </div>
  );
}
