"use client";

import { useEffect, useState } from "react";

const API_URL = `${process.env.NEXT_PUBLIC_API_URL}/banners`;
const IMAGE_BASE = `${process.env.NEXT_PUBLIC_IMAGE_BASE}/frontend/banner_promotional/`;

const PromoBanner = () => {
  const [banners, setBanners] = useState([]);

  useEffect(() => {
    fetch(API_URL)
      .then(res => res.json())
      .then(res => {
        if (res.status === "success") {
          setBanners(res.data);
        }
      })
      .catch(console.error);
  }, []);

  if (!banners.length) return null; // or loader

  return (
    <>
      {banners.map(item => (
        <div
          key={item.id}
          className="w-full h-48 overflow-hidden relative group cursor-pointer"
        >
          <a href={item.data_values?.link || "#"}>
            <img
              src={IMAGE_BASE + item.data_values?.image}
              alt="Promo banner"
              className="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300"
            />
          </a>
        </div>
      ))}
    </>
  );
};

export default PromoBanner;
