"use client";

import { useEffect, useState } from "react";
import OfferProductCard from "./OfferProductCard";


export default function OfferdProducts() {
    const [offerInfo, setOfferInfo] = useState();
    const [offerProducts, setOferProducts] = useState([]);
    const [activeProduct, setActiveProduct] = useState(0);
    const [loading, setLoading] = useState(true);


    useEffect(() => {
        fetch(`${process.env.NEXT_PUBLIC_API_URL}/offer-products`)
            .then((res) => res.json())
            .then((res) => {
                const offer = res?.data?.[0];

                if (offer) {
                    const { products, ...restOfferInfo } = offer;

                    setOferProducts(products || []);     // ✅ only products
                    setOfferInfo(restOfferInfo);          // ✅ everything except products
                }

                setLoading(false);
            })
            .catch((err) => {
                console.error("Offer products error:", err);
                setLoading(false);
            });
    }, []);


    const getDurationInDays = (startDate, endDate) => {
        const start = new Date(startDate);
        const end = new Date(endDate);

        const diffTime = end - start;

        if (diffTime <= 0) return 0;

        return Math.ceil(diffTime / (1000 * 60 * 60 * 24));
    };



    if (loading) {
        return <div className="py-10 text-center">Loading featured products...</div>;
    }


    const durationDays = getDurationInDays(
        offerInfo.start_date,
        offerInfo.end_date
    );


    if (!offerProducts.length) {
        return null;
    }

    // প্রতি slide এ 4টা product
    const slides = Math.ceil(offerProducts.length / 4);

    return (
        <div>
            {/* Header */}
            <div className="flex items-center justify-between mb-6">
                {/* Left side: title + duration */}
                <div className="flex items-center gap-2">
                    <h2 className="text-xl font-bold uppercase">
                        {offerInfo.name}
                    </h2>

                    {durationDays > 0 && (
                        <p className="text-sm text-gray-600">
                            Ends {durationDays} days from now
                        </p>
                    )}
                </div>

                {/* Right side: dots */}
                <div className="flex items-center gap-2">
                    {Array.from({ length: slides }).map((_, idx) => (
                        <button
                            key={idx}
                            onClick={() => setActiveProduct(idx)}
                            className={`w-3 h-3 rounded-full border-2 transition-all duration-300
          ${activeProduct === idx
                                    ? "bg-blue-500 border-blue-500 scale-110"
                                    : "bg-white border-gray-400"
                                }`}
                        />
                    ))}
                </div>
            </div>


            {/* Slider */}
            <div className="overflow-hidden">
                <div
                    className="flex transition-transform duration-500 ease-in-out"
                    style={{ transform: `translateX(-${activeProduct * 100}%)` }}
                >
                    {Array.from({ length: slides }).map((_, slideIdx) => (
                        <div
                            key={slideIdx}
                            className="min-w-full grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6"
                        >
                            {offerProducts
                                .slice(slideIdx * 4, slideIdx * 4 + 4)
                                .map((product) => (
                                    <OfferProductCard key={product.id} {...product} />
                                ))}
                        </div>
                    ))}
                </div>
            </div>
        </div>
    );
}
