import { Mail } from "lucide-react";

const Newsletter = () => {
  return (
    <div className="bg-gray-100 p-8">
      <div className="text-center space-y-4">
        <h3 className="text-xl font-bold uppercase">Subscribe Newsletter</h3>
        <p className="text-sm text-ecom-gray">
          Get all the latest information on Events, Sales and Offers.
        </p>

        {/* Input and Button (2-line layout) */}
        <div className="flex flex-col gap-3 items-stretch max-w-md mx-auto">
          <div className="relative">
            <Mail className="absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-ecom-gray" />
            <input
              type="email"
              placeholder="Email Address"
              className="w-full pl-10 pr-4 py-3 bg-white rounded-full focus:outline-none focus:ring-0 focus:ring-ecom-blue"
            />
          </div>

          <button className="bg-blue-500 text-white px-6 py-3 rounded font-semibold hover:bg-blue-600 transition-colors">
            Subscribe
          </button>
        </div>
      </div>
    </div>
  );
};

export default Newsletter;
