"use client";

import { useEffect, useState } from "react";
import { ChevronRight } from "lucide-react";
import RecursiveMenu from "./RecursiveMenu";

const API_URL = `${process.env.NEXT_PUBLIC_API_URL}/categories`;

export default function HomeCategories() {
  const [categories, setCategories] = useState([]);
  const [activeMain, setActiveMain] = useState(null);
  const [animate, setAnimate] = useState(false);

  useEffect(() => {
    fetch(API_URL)
      .then(res => res.json())
      .then(res => {
        if (res.status === "success") {
          setCategories(res.data);
        }
      })
      .catch(console.error);
  }, []);

  // first hover animation fix
  useEffect(() => {
    if (activeMain !== null) {
      requestAnimationFrame(() => setAnimate(true));
    } else {
      setAnimate(false);
    }
  }, [activeMain]);

  return (
    <aside className="relative">
      <div className="bg-gray-50 rounded w-full">
        {categories.map((cat, index) => (
          <div
            key={cat.id}
            className="relative"
            onMouseEnter={() => setActiveMain(index)}
            onMouseLeave={() => setActiveMain(null)}
          >
            {/* MAIN CATEGORY */}
            <div
              className={`
                flex justify-between items-center px-4 py-3 cursor-pointer
                ${activeMain === index
                  ? "bg-[#0088CC] text-white"
                  : "hover:bg-gray-100 text-gray-700"}
              `}
            >
              <a href={`/category/${cat.id}`}>
              <span className="text-sm">{cat.name}</span>
              </a>
              {cat.all_subcategories?.length > 0 && (
                <ChevronRight size={16} />
              )}
            </div>

            {/* FIRST LEVEL SUB MENU */}
            {activeMain === index &&
              cat.all_subcategories?.length > 0 && (
                <div
                  className={`
                    absolute left-full top-0 z-50
                    transition-all duration-200 ease-out
                    ${animate
                      ? "opacity-100 translate-x-0"
                      : "opacity-0 translate-x-3"}
                  `}
                >
                  <RecursiveMenu items={cat.all_subcategories} />
                </div>
              )}
          </div>
        ))}
      </div>
    </aside>
  );
}
