"use client";

import { useEffect, useState } from "react";
import FeaturedProductCard from "./FeaturedProductCard";


export default function FeaturedProducts() {
    const [products, setProducts] = useState([]);
    const [activeProduct, setActiveProduct] = useState(0);
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        fetch(`${process.env.NEXT_PUBLIC_API_URL}/featured-products`)
            .then((res) => res.json())
            .then((res) => {
                // ধরছি res.data এর ভিতরে product list আছে
                setProducts(res.data || []);
                setLoading(false);
            })
            .catch((err) => {
                console.error("Featured products error:", err);
                setLoading(false);
            });
    }, []);

    if (loading) {
        return <div className="py-10 text-center">Loading featured products...</div>;
    }

    if (!products.length) {
        return null;
    }

    // প্রতি slide এ 4টা product
    const slides = Math.ceil(products.length / 4);

    return (
        <div>
            {/* Header */}
            <div className="flex items-center justify-between mb-6">
                <h2 className="text-xl font-bold uppercase">Featured Products</h2>

                <div className="flex items-center gap-2">
                    {Array.from({ length: slides }).map((_, idx) => (
                        <button
                            key={idx}
                            onClick={() => setActiveProduct(idx)}
                            className={`w-3 h-3 rounded-full border-2 transition-all duration-300
                ${activeProduct === idx
                                    ? "bg-blue-500 border-blue-500 scale-110"
                                    : "bg-white border-gray-400"
                                }`}
                        />
                    ))}
                </div>
            </div>

            {/* Slider */}
            <div className="overflow-hidden">
                <div
                    className="flex transition-transform duration-500 ease-in-out"
                    style={{ transform: `translateX(-${activeProduct * 100}%)` }}
                >
                    {Array.from({ length: slides }).map((_, slideIdx) => (
                        <div
                            key={slideIdx}
                            className="min-w-full grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6"
                        >
                            {products
                                .slice(slideIdx * 4, slideIdx * 4 + 4)
                                .map((product) => (
                                    <FeaturedProductCard key={product.id} {...product} />
                                ))}
                        </div>
                    ))}
                </div>
            </div>
        </div>
    );
}
