import { Heart, ShoppingBag, ExternalLink } from "lucide-react";
import Link from "next/link";


export default function ProductCard({ product }) {
  return (
    <div
      className="
        group relative bg-white border border-gray-100 overflow-hidden
        transition-shadow duration-300
        hover:shadow-md
      "
    >
      {/* Image */}
      <Link href={`/product-details?slug=${product.slug}`} className="block">
        <div className="relative overflow-hidden">
          <img
            src={product.image}
            alt={product.name}
            className="w-full h-64 object-cover transition-transform duration-300 group-hover:scale-105"
          />

          {/* Badge */}
          <div className="absolute top-3 left-3 flex gap-2">
            {product.badge && (
              <span className="bg-green-500 text-white text-xs px-2 py-1">
                {product.badge}
              </span>
            )}
            {product.discount && (
              <span className="bg-red-500 text-white text-xs px-2 py-1">
                {product.discount}
              </span>
            )}
          </div>
        </div>
      </Link>

      {/* Info */}
      <div className="p-4 text-center">
        <p className="text-xs text-gray-400 uppercase">Category</p>

        <h3 className="text-sm font-medium mt-1 text-gray-400">
          Casual Spring Blue Shoes
        </h3>

        {/* Rating */}
        <div className="flex justify-center text-yellow-400 text-xs mt-1">
          ★★★★★
        </div>

        {/* Price */}
        <div className="mt-2">

          {product.originalPrice !== product.salePrice && (
            <span className="text-sm text-muted-foreground line-through mr-2">
              ${product.originalPrice.toFixed(2)}
            </span>
          )}
          <span className="text-lg font-semibold text-foreground">
            ৳{product.salePrice.toFixed(2)}
          </span>


          {/* <span className="line-through text-gray-400 text-sm mr-2">
            $90.00
          </span>
          <span className="font-semibold text-lg text-gray-400">
            $70.00
          </span> */}


        </div>

        {/* ACTION ROW */}
        <div className="mt-3 flex items-center justify-center gap-2">
          {/* Heart (LEFT) */}
          <button
            className="
              border border-gray-400 p-2 text-gray-400
              opacity-0 group-hover:opacity-100
              transition-opacity
              hover:bg-gray-100
            "
          >
            <Heart size={16} />
          </button>

          {/* ADD TO CART */}
          <button
            className="
              flex items-center justify-center gap-2 px-4 py-2
              border border-gray-400 text-gray-400
              text-sm font-medium
              transition-colors
              group-hover:bg-black group-hover:text-white group-hover:border-black
            "
          >
            <ShoppingBag size={16} />
            {product.buttonType === "cart" ? "Add to Cart" : "Select Options"}
          </button>

          {/* External Link (RIGHT) */}
          <button
            className="
              border border-gray-400 p-2 text-gray-400
              opacity-0 group-hover:opacity-100
              transition-opacity
              hover:bg-gray-100
            "
          >
            <ExternalLink size={16} />
          </button>
        </div>
      </div>
    </div>
  );
}
