"use client";

import { useEffect, useState } from "react";
import { getToken, getUser, logout } from "../../lib/auth";


import {
  X,
  ChevronDown,
  Search,
  Phone,
  User,
  Heart,
  ShoppingCart,
  Home as HomeIcon,
  Tag,
  ShoppingBag,
  FileText,
  BookOpen,
  Info,
  Gift,
  Star,
  Menu,
} from "lucide-react";
import { useSearchParams, usePathname } from "next/navigation";


import { Facebook, Twitter, Instagram } from "lucide-react";
import CartSidebar from "./CartSidebar";
import Link from "next/link";

export default function Header() {
  const [showTopBanner, setShowTopBanner] = useState(true);
  const [cartOpen, setCartOpen] = useState(false);
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);
  const [currencyOpen, setCurrencyOpen] = useState(false);
  const [langOpen, setLangOpen] = useState(false);

  const [searchKey, setSearchKey] = useState("");
  const [searchCategory, setSearchCategory] = useState("");
  const [categories, setCategories] = useState([]);

  const searchParams = useSearchParams();
  const pathname = usePathname();
  

const [loggedIn, setLoggedIn] = useState(null);
const [user, setUser] = useState(null);

const [cartCount, setCartCount] = useState(0);
  // load cart count on page load / reload
useEffect(() => {
  const updateCart = () => {
    const count = localStorage.getItem("cart_count");
    setCartCount(Number(count || 0));
  };

  updateCart(); // initial load
  window.addEventListener("cart-updated", updateCart);

  return () => window.removeEventListener("cart-updated", updateCart);
}, []);



useEffect(() => {
  const token = getToken();
  if (token) {
    setLoggedIn(true);
    setUser(getUser());
  } else {
    setLoggedIn(false);
  }
}, []);




  useEffect(() => {
    fetch(`${process.env.NEXT_PUBLIC_API_URL}/categories`)
      .then((res) => res.json())
      .then((res) => {
        setCategories(res?.data || []);
      });

    if (pathname !== "/search") return;
    const key = searchParams.get("search_key") || "";
    const cat = searchParams.get("category_id") || "";
    setSearchKey(key);
    setSearchCategory(cat);


  }, [searchParams, pathname]);




  const cartItems = [
    {
      id: 1,
      name: "Ultimate 3D Bluetooth Speaker",
      price: 34.0,
      quantity: 1,
      image: "https://via.placeholder.com/80x80",
    },
    {
      id: 2,
      name: "Brown Women Casual HandBag",
      price: 35.0,
      quantity: 1,
      image: "https://via.placeholder.com/80x80",
    },
    {
      id: 3,
      name: "Circled Ultimate 3D Speaker",
      price: 35.0,
      quantity: 1,
      image: "https://via.placeholder.com/80x80",
    },
  ];

  const menuItems = [
    { icon: HomeIcon, label: "Home", hasSubmenu: false },
    {
      icon: Tag,
      label: "Categories",
      hasSubmenu: true,
      submenu: ["Electronics", "Fashion", "Home & Garden"],
    },
    {
      icon: ShoppingBag,
      label: "Products",
      hasSubmenu: true,
      submenu: {
        "PRODUCT PAGES": [
          "SIMPLE PRODUCT",
          "VARIABLE PRODUCT",
          "SALE PRODUCT",
          "FEATURED & ON SALE",
          "WITH CUSTOM TAB",
          "WITH LEFT SIDEBAR",
          "WITH RIGHT SIDEBAR",
          "ADD CART STICKY",
        ],
        "PRODUCT LAYOUTS": [
          "EXTENDED LAYOUT",
          "GRID IMAGE",
          "FULL WIDTH LAYOUT",
          "STICKY INFO",
          "LEFT & RIGHT STICKY",
          "TRANSPARENT IMAGE",
          "CENTER VERTICAL",
          "BUILD YOUR OWN",
        ],
      },
    },
    {
      icon: FileText,
      label: "Pages",
      hasSubmenu: true,
      submenu: ["About", "Contact", "FAQ"],
    },
    { icon: BookOpen, label: "Blog", hasSubmenu: false },
    { icon: Info, label: "About Us", hasSubmenu: false },
    { icon: Gift, label: "Special Offer!", hasSubmenu: false },
    { icon: Star, label: "Buy Porto!", badge: "HOT", hasSubmenu: false },
  ];

  return (
    <>
      {/* {showTopBanner && (
        <div className="bg-[#2B2B2D] text-white py-2 px-4 relative">
          <div className="max-w-7xl mx-auto flex items-center justify-center gap-4 text-sm">
            <span>
              Get Up to <strong>40% OFF</strong> New-Season Styles
            </span>
            <a href="#" className="underline hover:no-underline">
              MEN
            </a>
            <a href="#" className="underline hover:no-underline">
              WOMEN
            </a>
            <span className="text-gray-400 text-xs">* Limited time only.</span>
            <button
              onClick={() => setShowTopBanner(false)}
              className="absolute right-4 hover:text-gray-400 transition-colors"
            >
              <X size={18} />
            </button>
          </div>
        </div>
      )} */}

      <div className="bg-[#0088CC] text-white py-2 px-4 text-xs">
        <div className="max-w-7xl mx-auto flex items-center justify-between">
          <div className="flex items-center gap-6">


            {/* <div className="relative">
              <button
                onClick={() => setLanguageOpen(!languageOpen)}
                className="flex items-center gap-1 hover:text-gray-200 transition-colors"
              >
                <span className="text-red-500">🇺🇸</span>
                <span>ENG</span>
                <ChevronDown size={12} />
              </button>

              <div
                className={`absolute top-full left-0 mt-1 bg-white text-black shadow-lg rounded py-1 min-w-[100px] z-50 transition-all duration-300 origin-top ${languageOpen
                  ? 'opacity-100 scale-y-100 visible'
                  : 'opacity-0 scale-y-0 invisible'
                  }`}
              >
                <a
                  href="#"
                  className="block px-4 py-2 hover:bg-gray-100 transition-colors"
                >
                  ENG
                </a>
                <a
                  href="#"
                  className="block px-4 py-2 hover:bg-gray-100 transition-colors"
                >
                  FRA
                </a>
                <a
                  href="#"
                  className="block px-4 py-2 hover:bg-gray-100 transition-colors"
                >
                  EUR
                </a>
              </div>
            </div> */}

            {/* Language Selector */}
            <div className="relative">
              <button
                onMouseEnter={() => setLangOpen(true)}
                onMouseLeave={() => setLangOpen(false)}
                className="flex items-center gap-1 hover:opacity-80 transition-opacity"
              >
                <span>ENG</span>
                <ChevronDown className="w-3 h-3" />
              </button>
              {langOpen && (
                <div
                  onMouseEnter={() => setLangOpen(true)}
                  onMouseLeave={() => setLangOpen(false)}
                  className="absolute top-full left-0 mt-1 bg-white text-black rounded shadow-lg py-2 w-32 z-50"
                >
                  <a href="#" className="block px-4 py-2 hover:bg-gray-100 transition-colors">ENG</a>
                  <a href="#" className="block px-4 py-2 hover:bg-gray-100 transition-colors">FRA</a>
                  <a href="#" className="block px-4 py-2 hover:bg-gray-100 transition-colors">EUR</a>
                </div>
              )}
            </div>


            <div className="relative">
              <button
                onMouseEnter={() => setCurrencyOpen(true)}
                onMouseLeave={() => setCurrencyOpen(false)}
                className="flex items-center gap-1 hover:text-gray-200 transition-colors"
              >
                <span>USD</span>
                <ChevronDown size={12} />
              </button>
              {currencyOpen && (
                <div className="absolute top-full left-0 mt-1 bg-white text-black shadow-lg rounded py-1 min-w-[100px] z-50">
                  <a
                    href="#"
                    className="block px-4 py-2 hover:bg-gray-100 transition-colors"
                  >
                    EUR
                  </a>
                  <a
                    href="#"
                    className="block px-4 py-2 hover:bg-gray-100 transition-colors"
                  >
                    USD
                  </a>
                </div>
              )}
            </div>
          </div>

          <div className="hidden md:flex items-center gap-6">

            {loggedIn ? (
              <>
                <a className="hover:text-gray-200 uppercase">
                    WELCOME, {user?.firstname ?? "USER"}!
                </a>

                <a href="/dashboard" className="hover:text-gray-200 uppercase">
                  MY ACCOUNT
                </a>
                <a
                  href="#"
                  className="hover:text-gray-200 transition-colors uppercase"
                >
                  MY WISHLIST
                </a>
                <a
                 onClick={logout}
                  href="#"
                  className="hover:text-gray-200 transition-colors uppercase"
                >
                 LOG OUT
                </a>
              </>
            ) : (
              <a href="/login" className="hover:text-gray-200 uppercase">
                LOG IN
              </a>
            )}





            <div className="flex items-center gap-3">
              <a
                href="#"
                className="hover:text-gray-200 transition-colors"
                aria-label="Facebook"
              >
                <Facebook size={14} />
              </a>
              <a
                href="#"
                className="hover:text-gray-200 transition-colors"
                aria-label="Twitter"
              >
                <Twitter size={14} />
              </a>
              <a
                href="#"
                className="hover:text-gray-200 transition-colors"
                aria-label="Instagram"
              >
                <Instagram size={14} />
              </a>
            </div>
          </div>


        </div>
      </div>

      <header className="border-b border-gray-200">
        <div className="max-w-7xl mx-auto px-4 py-4">
          <div className="flex items-center justify-between gap-8">
            <button
              onClick={() => setMobileMenuOpen(true)}
              className="lg:hidden p-2 hover:bg-gray-100 rounded transition-colors"
            >
              <Menu size={24} />
            </button>

            <div className="flex items-center gap-2">
              {/* <div className="text-[#0088CC] font-bold text-3xl">PORTO</div> */}
              {/* <div className="text-gray-400 text-xs">eCommerce</div> */}
              <Link href={`/`} className="block">
                <img
                  src="/emela-logo.png"
                  alt="Logo"
                  className="w-50 h-20 object-cover rounded"
                />
              </Link>
            </div>


            <div className="hidden md:flex items-center flex-1 max-w-2xl">
              <form
                onSubmit={(e) => {
                  e.preventDefault();
                  if (!searchKey) return;

                  const query = new URLSearchParams();
                  query.append("search_key", searchKey);

                  if (searchCategory) {
                    query.append("category_id", searchCategory);
                  }

                  window.location.href = `/search?${query.toString()}`;
                }}
                className="relative flex-1 flex"
              >
                <input
                  type="text"
                  placeholder="Search..."
                  value={searchKey}
                  onChange={(e) => setSearchKey(e.target.value)}
                  className="w-full px-4 py-3 border border-gray-300 rounded-l focus:outline-none focus:border-[#0088CC]"
                />

                <div className="relative">
                  <select
                    value={searchCategory}
                    onChange={(e) => setSearchCategory(e.target.value)}
                    className="h-full px-4 py-3 border-t border-b border-gray-300 bg-white text-sm text-gray-600 appearance-none pr-8 focus:outline-none focus:border-[#0088CC]"
                  >
                    <option value="">All Categories</option>

                    {/* 🔥 categories API theke ashbe */}
                    {categories?.map((cat) => (
                      <option key={cat.id} value={cat.id}>
                        {cat.name}
                      </option>
                    ))}
                  </select>

                  <ChevronDown
                    size={16}
                    className="absolute right-2 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none"
                  />
                </div>

                <button
                  type="submit"
                  className="px-6 bg-[#0088CC] text-white rounded-r hover:bg-[#0077B3]"
                >
                  <Search size={20} />
                </button>
              </form>
            </div>


            {/* <div className="hidden md:flex items-center flex-1 max-w-2xl">
              <div className="relative flex-1 flex">
                <input
                  type="text"
                  placeholder="Search..."
                  className="w-full px-4 py-3 border border-gray-300 rounded-l focus:outline-none focus:border-[#0088CC] transition-colors"
                />
                <div className="relative">
                  <select className="h-full px-4 py-3 border-t border-b border-gray-300 bg-white text-sm text-gray-600 appearance-none pr-8 focus:outline-none focus:border-[#0088CC] transition-colors">
                    <option>All Categories</option>
                    <option>Electronics</option>
                    <option>Fashion</option>
                    <option>Home</option>
                  </select>
                  <ChevronDown
                    size={16}
                    className="absolute right-2 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none"
                  />
                </div>
                <button className="px-6 bg-[#0088CC] text-white rounded-r hover:bg-[#0077B3] transition-colors">
                  <Search size={20} />
                </button>
              </div>
            </div> */}



            <div className="flex items-center gap-6">
              <div className="hidden lg:flex items-center gap-2">
                <Phone size={28} className="text-[#0088CC]" />
                <div>
                  <div className="text-xs text-gray-500">CALL US NOW</div>
                  <div className="font-semibold text-sm">+123 5678 890</div>
                </div>
              </div>

              <div className="flex items-center gap-4">
                <button className="p-2 hover:text-[#0088CC] transition-colors">
                  <Heart size={24} />
                </button>
                <button className="p-2 hover:text-[#0088CC] transition-colors">
                  <Link href={`/login`} className="block">
                    <User size={24} />
                  </Link>
                </button>


                {/* <button
                  onClick={() => setCartOpen(true)}
                  className="relative p-2 hover:text-[#0088CC] transition-colors"
                >
                  <ShoppingCart size={24} />
                  <span className="absolute -top-1 -right-1 bg-[#0088CC] text-white text-xs w-5 h-5 flex items-center justify-center rounded-full">
                    3
                  </span>
                </button> */}

              <Link href="/cart" className="block">
  <button className="relative p-2 hover:text-[#0088CC] transition-colors">
    <ShoppingCart size={24} />

   {cartCount > 0 && (
          <span className="absolute -top-1 -right-1 bg-[#0088CC] text-white text-xs w-5 h-5 flex items-center justify-center rounded-full">
            {cartCount}
          </span>
        )}
  </button>
</Link>


              </div>
            </div>
          </div>
        </div>
      </header>

      {mobileMenuOpen && (
        <>
          <div
            className="fixed inset-0 bg-black bg-opacity-50 z-40"
            onClick={() => setMobileMenuOpen(false)}
          ></div>
          <div className="fixed left-0 top-0 h-full w-full max-w-xs bg-[#2B2B2D] text-white shadow-2xl z-50 overflow-y-auto">
            <div className="p-6">
              <button
                onClick={() => setMobileMenuOpen(false)}
                className="absolute top-4 right-4 text-white hover:text-gray-400 transition-colors"
              >
                <X size={24} />
              </button>

              <nav className="mt-8 space-y-1">
                {menuItems.map((item, index) => (
                  <div key={index}>
                    <a
                      href="#"
                      className="flex items-center justify-between py-3 px-4 hover:bg-gray-700 rounded transition-colors"
                    >
                      <div className="flex items-center gap-3">
                        <item.icon size={20} />
                        <span className="uppercase text-sm">{item.label}</span>
                        {item.badge && (
                          <span className="bg-red-500 text-white text-xs px-2 py-0.5 rounded">
                            {item.badge}
                          </span>
                        )}
                      </div>
                      {item.hasSubmenu && <ChevronDown size={16} />}
                    </a>
                  </div>
                ))}
              </nav>

              <div className="mt-8 pt-6 border-t border-gray-700 space-y-3">
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  MY ACCOUNT
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  CONTACT US
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  MY WISHLIST
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  SITE MAP
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  CART
                </a>
                <a
                  href="#"
                  className="block py-2 hover:text-[#0088CC] transition-colors"
                >
                  LOG IN
                </a>
              </div>

              <div className="mt-6 pt-6 border-t border-gray-700">
                <div className="relative mb-4">
                  <input
                    type="text"
                    placeholder="Search..."
                    className="w-full px-4 py-2 bg-gray-700 text-white rounded focus:outline-none focus:ring-2 focus:ring-[#0088CC]"
                  />
                  <Search
                    size={20}
                    className="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400"
                  />
                </div>

                <div className="flex items-center justify-center gap-4">
                  <a
                    href="#"
                    className="w-10 h-10 bg-[#3B5998] flex items-center justify-center rounded hover:bg-opacity-80 transition-colors"
                    aria-label="Facebook"
                  >
                    <Facebook size={18} />
                  </a>
                  <a
                    href="#"
                    className="w-10 h-10 bg-[#1DA1F2] flex items-center justify-center rounded hover:bg-opacity-80 transition-colors"
                    aria-label="Twitter"
                  >
                    <Twitter size={18} />
                  </a>
                  <a
                    href="#"
                    className="w-10 h-10 bg-gradient-to-r from-[#F58529] via-[#DD2A7B] to-[#8134AF] flex items-center justify-center rounded hover:opacity-80 transition-opacity"
                    aria-label="Instagram"
                  >
                    <Instagram size={18} />
                  </a>
                </div>
              </div>
            </div>
          </div>
        </>
      )}

      {/* {cartOpen && (
        <>
          <div
            className="fixed inset-0 bg-black bg-opacity-50 z-40"
            onClick={() => setCartOpen(false)}
          ></div>
          <div className="fixed right-0 top-0 h-full w-full max-w-md bg-white shadow-2xl z-50 overflow-y-auto">
            <div className="p-6">
              <div className="flex items-center justify-between mb-6">
                <h2 className="text-xl font-semibold">Shopping Cart</h2>
                <button
                  onClick={() => setCartOpen(false)}
                  className="p-2 hover:bg-gray-100 rounded transition-colors"
                >
                  <X size={24} />
                </button>
              </div>

              <div className="space-y-4 mb-6">
                {cartItems.map((item) => (
                  <div
                    key={item.id}
                    className="flex gap-4 pb-4 border-b border-gray-200"
                  >
                    <img
                      src={item.image}
                      alt={item.name}
                      className="w-20 h-20 object-cover rounded"
                    />
                    <div className="flex-1">
                      <h3 className="text-sm font-medium mb-2">{item.name}</h3>
                      <div className="flex items-center justify-between">
                        <span className="text-sm">
                          {item.quantity} × ${item.price.toFixed(2)}
                        </span>
                      </div>
                    </div>
                    <button className="text-gray-400 hover:text-red-500 transition-colors">
                      <X size={18} />
                    </button>
                  </div>
                ))}
              </div>

              <div className="border-t border-gray-200 pt-4 mb-6">
                <div className="flex items-center justify-between text-lg font-semibold">
                  <span>SUBTOTAL:</span>
                  <span className="text-[#0088CC]">$134.00</span>
                </div>
              </div>

              <div className="space-y-3">
                <button className="w-full bg-white text-[#0088CC] border-2 border-[#0088CC] py-3 rounded font-semibold hover:bg-[#0088CC] hover:text-white transition-colors">
                  VIEW CART
                </button>
                <button className="w-full bg-[#0088CC] text-white py-3 rounded font-semibold hover:bg-[#0077B3] transition-colors">
                  CHECKOUT
                </button>
              </div>
            </div>
          </div>
        </>
      )} */}




      <CartSidebar isOpen={cartOpen} onClose={() => setCartOpen(false)} />




    </>
  );
}
