export default function Footer() {
  return (
    <footer className="bg-gray-900 text-gray-300 pt-12 pb-6">
      <div className="max-w-7xl mx-auto px-4 grid grid-cols-1 md:grid-cols-4 gap-8">
        {/* About Us */}
        <div>
          <h3 className="text-white text-lg font-semibold mb-4">About Us</h3>
          <p className="text-sm mb-2">
            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore.
          </p>
          <a href="#" className="text-blue-400 text-sm hover:underline">Read more...</a>
        </div>

        {/* Contact Info */}
        <div>
          <h3 className="text-white text-lg font-semibold mb-4">Contact Info</h3>
          <ul className="text-sm space-y-2">
            <li>123 Street Name, City, England</li>
            <li>(123) 456-7890</li>
            <li>mail@example.com</li>
            <li>Mon - Sun / 9:00 AM - 8:00 PM</li>
          </ul>
        </div>

        {/* Customer Service */}
        <div>
          <h3 className="text-white text-lg font-semibold mb-4">Customer Service</h3>
          <ul className="text-sm space-y-2">
            <li><a href="#" className="hover:text-white">Help & FAQs</a></li>
            <li><a href="#" className="hover:text-white">Order Tracking</a></li>
            <li><a href="#" className="hover:text-white">Shipping & Delivery</a></li>
            <li><a href="#" className="hover:text-white">Orders History</a></li>
          </ul>
        </div>

        {/* Popular Tags */}
        <div>
          <h3 className="text-white text-lg font-semibold mb-4">Popular Tags</h3>
          <div className="flex flex-wrap gap-2">
            {['Bag', 'Black', 'Blue', 'Clothes', 'Fashion', 'Hub', 'Shirt', 'Shoes', 'Skirt', 'Sports', 'Winter'].map(tag => (
              <a key={tag} href="#" className="bg-gray-700 hover:bg-gray-600 text-sm px-3 py-1 rounded">{tag}</a>
            ))}
          </div>
        </div>
      </div>

      {/* Footer Bottom */}
      <div className="border-t border-gray-700 mt-12 pt-6 text-center text-sm">
        <p>© Porto eCommerce. 2021. All Rights Reserved.</p>
        <div className="mt-4 flex justify-center gap-4">
          <img src="/icons/visa.svg" alt="Visa" className="h-6" />
          <img src="/icons/paypal.svg" alt="PayPal" className="h-6" />
          <img src="/icons/stripe.svg" alt="Stripe" className="h-6" />
          <img src="/icons/mastercard.svg" alt="MasterCard" className="h-6" />
        </div>
      </div>
    </footer>
  );
}
