import { X, ShoppingBag } from "lucide-react";

const CartSidebar = ({ isOpen, onClose }) => {


    const cartItems = [
    {
      id: 1,
      image: "https://id-preview--753e56e4-39d6-4da2-afe3-212de7bb8ae3.lovable.app/assets/watch-product-CKNdCwrs.jpg",
      category: "Electronics",
      name: "Black Grey Headset",
      price: 9.0,
      rating: 5,
      isHot: true,
      discount: 20,
      hasCountdown: true,
    },
    {
      id: 2,
      image: "https://portotheme.com/html/porto_ecommerce/assets/images/demoes/demo1/products/product-2.jpg",
      category: "Electronics",
      name: "Battery Charger",
      price: 9.0,
      rating: 5,
      hasQuickView: true,
    },
  ];



  return (
    <>
      {/* Overlay */}
      {isOpen && (
        <div
          className="fixed inset-0 bg-black/50 z-40 transition-opacity"
          onClick={onClose}
        />
      )}

      {/* Sidebar */}
      <div
        className={`fixed top-0 right-0 h-full w-full sm:w-96 bg-white shadow-2xl z-50 transform transition-transform duration-300 ${
          isOpen ? "translate-x-0" : "translate-x-full"
        }`}
      >
        <div className="flex flex-col h-full">
          {/* Header */}
          <div className="flex items-center justify-between p-4 border-b border-border">
            <h2 className="text-lg font-semibold flex items-center gap-2">
              <ShoppingBag className="w-5 h-5" />
              Shopping Cart
            </h2>
            <button
              onClick={onClose}
              className="p-2 hover:bg-ecom-light-gray rounded transition-colors"
              aria-label="Close cart"
            >
              <X className="w-5 h-5" />
            </button>
          </div>

          {/* Cart Content */}
          <div className="flex-1 overflow-y-auto p-4">


             {cartItems.map((item) => (
                  <div
                    key={item.id}
                    className="flex gap-4 pb-4 border-b border-gray-200"
                  >
                    <img
                      src={item.image}
                      alt={item.name}
                      className="w-20 h-20 object-cover rounded"
                    />
                    <div className="flex-1">
                      <h3 className="text-sm font-medium mb-2">{item.name}</h3>
                      <div className="flex items-center justify-between">
                        <span className="text-sm">
                          {item.quantity} × ${item.price.toFixed(2)}
                        </span>
                      </div>
                    </div>
                    <button className="text-gray-400 hover:text-red-500 transition-colors">
                      <X size={18} />
                    </button>
                  </div>
                ))}


                
              {/* <div className="border-t border-gray-200 pt-4 mb-6">
                <div className="flex items-center justify-between text-lg font-semibold">
                  <span>SUBTOTAL:</span>
                  <span className="text-[#0088CC]">$134.00</span>
                </div>
              </div> */}

            

{/* 
            <div className="flex flex-col items-center justify-center h-full text-center">
              <ShoppingBag className="w-16 h-16 text-ecom-gray mb-4" />
              <p className="text-ecom-gray mb-2">Your cart is empty</p>
              <button
                onClick={onClose}
                className="bg-ecom-blue text-white px-6 py-2 rounded-lg hover:bg-blue-600 transition-colors"
              >
                Continue Shopping
              </button>
            </div> */}


          </div>

          {/* Footer */}
          <div className="border-t border-border p-4 space-y-4">
            <div className="flex items-center justify-between">
              <span className="font-semibold">Subtotal:</span>
              <span className="text-xl font-bold text-ecom-blue">$0.00</span>
            </div>
        
        
          <div className="space-y-3">
                <button className="w-full bg-white text-[#0088CC] border-2 border-[#0088CC] py-3 rounded font-semibold hover:bg-[#0088CC] hover:text-white transition-colors">
                  VIEW CART
                </button>
                <button className="w-full bg-[#0088CC] text-white py-3 rounded font-semibold hover:bg-[#0077B3] transition-colors">
                  CHECKOUT
                </button>
              </div>


          </div>
        </div>
      </div>
    </>
  );
};

export default CartSidebar;
