

import LogoutButton from "../components/LogoutButton";
import AuthGuard from "../components/AuthGuard";

export default function CheckoutPage() {
    return (
        <AuthGuard>

            <main className="max-w-7xl mx-auto">
                <div className="container mx-auto px-4 py-10 grid md:grid-cols-3 gap-8">
                    {/* Billing Details */}
                    <div className="md:col-span-2">


                        <form className="space-y-8">
                            <h2 className="text-2xl font-semibold mb-6">Billing Details</h2>

                            <div className="grid grid-cols-2 gap-6">
                                <label className="flex flex-col">
                                    <span className="mb-2 text-gray-700">First Name</span>
                                    <input
                                        type="text"
                                        placeholder="First name"
                                        className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                        required
                                    />
                                </label>

                                <label className="flex flex-col">
                                    <span className="mb-2 text-gray-700">Last Name</span>
                                    <input
                                        type="text"
                                        placeholder="Last name"
                                        className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                        required
                                    />
                                </label>
                            </div>

                            <label className="flex flex-col">
                                <span className="mb-2 text-gray-700">Company Name (Optional)</span>
                                <input
                                    type="text"
                                    placeholder="Company name"
                                    className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                />
                            </label>

                            <label className="flex flex-col">
                                <span className="mb-2 text-gray-700">Country</span>
                                <select
                                    className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                    defaultValue="Yamush"
                                >
                                    <option>Yamush</option>
                                    <option>Bangladesh</option>
                                    <option>USA</option>
                                </select>
                            </label>

                            <label className="flex flex-col">
                                <span className="mb-2 text-gray-700">Street Address</span>
                                <input
                                    type="text"
                                    placeholder="Street address"
                                    className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                    required
                                />
                            </label>

                            <label className="flex flex-col">
                                <span className="mb-2 text-gray-700">Apartment, Suite, Unit (Optional)</span>
                                <input
                                    type="text"
                                    placeholder="Apartment, suite, unit"
                                    className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                />
                            </label>

                            <div className="grid grid-cols-2 gap-6">
                                <label className="flex flex-col">
                                    <span className="mb-2 text-gray-700">Town / City</span>
                                    <input
                                        type="text"
                                        placeholder="Town / City"
                                        className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                        required
                                    />
                                </label>

                                <label className="flex flex-col">
                                    <span className="mb-2 text-gray-700">State</span>
                                    <select
                                        className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                        defaultValue="NY"
                                    >
                                        <option>NY</option>
                                        <option>CA</option>
                                        <option>TX</option>
                                    </select>
                                </label>
                            </div>

                            <label className="flex flex-col">
                                <span className="mb-2 text-gray-700">Postcode / ZIP</span>
                                <input
                                    type="text"
                                    placeholder="Postcode / ZIP"
                                    className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                    required
                                />
                            </label>

                            <label className="flex flex-col">
                                <span className="mb-2 text-gray-700">Phone</span>
                                <input
                                    type="tel"
                                    placeholder="Phone"
                                    className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                    required
                                />
                            </label>

                            <label className="flex flex-col">
                                <span className="mb-2 text-gray-700">Email Address</span>
                                <input
                                    type="email"
                                    placeholder="Email address"
                                    className="border border-gray-300 px-4 py-3 w-full focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                    required
                                />
                            </label>

                            <div className="space-y-4">
                                <label className="flex items-center space-x-2">
                                    <input
                                        type="checkbox"
                                        className="w-4 h-4 text-black border-gray-300 focus:ring-1 focus:ring-gray-400"
                                    />
                                    <span>Create an account?</span>
                                </label>

                                <label className="flex flex-col">
                                    <span className="mb-2 text-gray-700">Order Notes (Optional)</span>
                                    <textarea
                                        placeholder="Order notes"
                                        className="border border-gray-300 px-4 py-3 w-full h-28 resize-none focus:ring-1 focus:ring-gray-400 focus:outline-none"
                                    />
                                </label>
                            </div>
                        </form>

                    </div>

                    {/* Order Summary */}


                    <div className="border border-gray-200 p-6 rounded-md h-fit bg-white space-y-6">
                        <h2 className="text-2xl font-semibold text-gray-800 mb-4">Your Order</h2>

                        {/* Products */}
                        <div className="space-y-4">
                            <div className="flex justify-between text-gray-700 py-2 font-medium">
                                <span>Product</span>
                                <span>Subtotal</span>
                            </div>
                            <hr className="border-gray-300" />

                            <div className="flex justify-between text-gray-700 py-2">
                                <span>Cricleid Ultimate 3D Speaker × 4</span>
                                <span>$1,408.00</span>
                            </div>
                            <div className="flex justify-between text-gray-700 py-2">
                                <span>Fashion Computer Bag × 2</span>
                                <span>$195.00</span>
                            </div>
                            <div className="flex justify-between text-gray-700 py-2">
                                <span>Subtotal</span>
                                <span>$195.00</span>
                            </div>
                        </div>



                        {/* Shipping */}
                        <div className="space-y-3">
                            <h3 className="font-medium text-gray-800">Shipping</h3>
                            <hr className="border-gray-300" />
                            <label className="flex items-center space-x-3 text-gray-700 py-2">
                                <input
                                    type="radio"
                                    name="shipping"
                                    defaultChecked
                                    className="w-4 h-4 border-gray-300 focus:ring-1 focus:ring-gray-400"
                                />
                                <span>Local Pickup</span>
                            </label>
                            <label className="flex items-center space-x-3 text-gray-700 py-2">
                                <input
                                    type="radio"
                                    name="shipping"
                                    className="w-4 h-4 border-gray-300 focus:ring-1 focus:ring-gray-400"
                                />
                                <span>Flat rate</span>
                            </label>
                            <hr className="border-gray-300" />
                        </div>

                        {/* Total */}
                        <div className="flex justify-between font-semibold text-lg text-gray-800 py-2">
                            <span>Total:</span>
                            <span>$1,603.00</span>
                        </div>
                        <hr className="border-gray-300" />

                        <div className="text-red-600 text-sm py-2">
                            Sorry, it seems that there are no available payment methods for your state. Please contact us if you require assistance or wish to make alternate arrangements.
                        </div>

                        <button className="w-full bg-black text-white py-3 rounded hover:bg-gray-800 transition">
                            PLACE ORDER
                        </button>
                    </div>


                </div>
            </main>

        </AuthGuard>
    );
}


